<?php
namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Models\Shift;
use App\Models\Jabatan;
use App\Models\Karyawan;
use App\Models\JatahCuti;
use App\Models\Departemen;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class KaryawanController extends Controller
{
    public function index()
    {
        $karyawan = Karyawan::with(['user','departemen', 'jabatan'])->paginate(20);
        $jabatan = Jabatan::all();
        // $jatahSaldo = JatahSaldo::all();
        $user = User::whereDoesntHave('karyawan')->get();
                $departemen = Departemen::all();

        return view('admin.karyawan.index', compact('karyawan', 'jabatan', 'user', 'departemen'));
    }

    public function create()
    {
        $jabatan = Jabatan::all();
        $departemen = Departemen::all();
        $jatahCuti = JatahCuti::all();

        return view('admin.karyawan.create', compact('jabatan','departemen', 'jatahCuti'));
    }

    public function store(Request $request)
{
    $request->validate([
        'user_id' => 'required|exists:users,id|unique:karyawan,user_id',
        'nip' => 'required|unique:karyawan,nip',
        'departemen_id' => 'required',
        'jabatan_id' => 'required|exists:jabatan,id',
    ]);

    DB::beginTransaction();
    try {
        // Aktifkan user
        $user = User::findOrFail($request->user_id);
        $user->update(['status' => 'aktif']);

        // Buat karyawan
        $karyawan = Karyawan::create([
            'user_id' => $user->id,
            'nip' => $request->nip,
            'departemen_id' => $request->departemen_id,
            'jabatan_id' => $request->jabatan_id,
            'status' => 'aktif',
        ]);

        JatahCuti::create([
        'karyawan_id' => $karyawan->id,
        'tahun' => now()->year,
        'jatah' => 6
    ]);

        activity_log(
            'karyawan',
            'create',
            'Menambahkan karyawan ' . $karyawan->user->nama
        );


        DB::commit();
        return redirect()->route('admin.karyawan.index')
            ->with('success', 'Karyawan berhasil diaktifkan');
    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors(['error' => 'Gagal mengaktifkan karyawan']);
    }
}


    public function edit($id)
    {
        $karyawan = Karyawan::with('user')->findOrFail($id);
        $jabatan = Jabatan::all();
        $departemen = Departemen::all();

        return view('admin.karyawan.edit', compact('karyawan', 'jabatan', 'departemen'));
    }

    public function update(Request $request, $id)
    {
        $karyawan = Karyawan::with('user')->findOrFail($id);

        $request->validate([
            'nip' => 'required|unique:karyawan,nip,' . $id,
            'departemen_id' => 'required',
            'jabatan_id' => 'required|exists:jabatan,id',
            'status' => 'required|in:aktif,nonaktif',
        ]);

        DB::beginTransaction();
        try {
            $karyawan->update([
                'nip' => $request->nip,
                'departemen_id' => $request->departemen_id,
                'jabatan_id' => $request->jabatan_id,
                'status' => $request->status,
            ]);

            $karyawan->user->update([
                'status' => $request->status,
            ]);

            activity_log(
                'karyawan',
                'update',
                'Mengubah data karyawan ' . $karyawan->user->nama
            );


            DB::commit();
            return redirect()->route('admin.karyawan.index')
                ->with('success', 'Data karyawan berhasil diupdate');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'Gagal update karyawan']);
        }
    }


    public function destroy($id)
    {
        $karyawan = Karyawan::with('user')->findOrFail($id);

        DB::beginTransaction();
        try {
            $karyawan->user->delete(); // otomatis hapus karyawan via FK
            DB::commit();

            activity_log(
                'karyawan',
                'delete',
                'Menghapus karyawan ' . $karyawan->user->nama
            );

            return redirect()->route('admin.karyawan.index')
                ->with('success', 'Karyawan berhasil dihapus');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'Gagal menghapus karyawan']);
        }
    }

}
